# How to View and Edit .env File on Mac

## Option 1: Using Terminal (Easiest)

### Step 1: Open Terminal
- Press `Cmd + Space`
- Type "Terminal"
- Press Enter

### Step 2: Navigate to Your Project
```bash
cd "/Users/hicham/Downloads/Gemine Test"
```

### Step 3: Open .env File
```bash
open -e .env
```
This will open the `.env` file in TextEdit!

---

## Option 2: Show Hidden Files in Finder

### Step 1: Show Hidden Files
Press these keys together:
```
Cmd + Shift + .
```
(That's Command + Shift + Period)

### Step 2: Navigate to Your Project
Go to: `/Users/hicham/Downloads/Gemine Test`

### Step 3: Find .env File
You should now see the `.env` file! Double-click to open it.

### Step 4: Hide Files Again (Optional)
Press `Cmd + Shift + .` again to hide them.

---

## Option 3: Using VS Code (If You Have It)

### Step 1: Open Terminal
```bash
cd "/Users/hicham/Downloads/Gemine Test"
code .env
```

This opens the `.env` file directly in VS Code!

---

## What to Add to .env for Shopify

Once you open the `.env` file, add these lines at the bottom:

```env
# Shopify Integration Settings
SHOPIFY_API_VERSION=2024-01
```

**Note**: You DON'T need to add your Shopify credentials to `.env`!  
They're stored securely in the database when you connect through the dashboard.

---

## Quick Command Reference

```bash
# Navigate to project
cd "/Users/hicham/Downloads/Gemine Test"

# View .env file
cat .env

# Edit .env file
nano .env
# (Press Ctrl+X to exit, Y to save)

# Or open in TextEdit
open -e .env
```

---

## ⚠️ Important Notes

1. **Never commit .env to Git** - It contains sensitive data
2. **The .env file should already exist** - Laravel creates it during installation
3. **Shopify credentials go in the database** - Not in .env (more secure!)

---

## Need Help?

If the `.env` file doesn't exist, you can create it:

```bash
cd "/Users/hicham/Downloads/Gemine Test"
cp .env.example .env
php artisan key:generate
```

Then add the Shopify settings shown above!
